const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_temp_masterhtd', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    MstSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    WgmtModeNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    ProductType: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CubicleName: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    CubicleType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },   
    IPQCType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    CoatingType: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MachineCode: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },      
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    BFGCode: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    ProductName: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchNo: {
      type: DataTypes.STRING(25),
      allowNull: true,
      defaultValue: "NULL"
    },
    BatchSize: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    BMRNo: {
      type: DataTypes.STRING(150),
      allowNull: true,
      defaultValue: "NULL"
    },
    GraphType: {
      type: DataTypes.STRING(15),
      allowNull: false,
      defaultValue: "NULL",
      comment: "0:Standard 1: Average"
    },
    Qty: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    GrpQty: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    GrpFreq: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Idsno: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    HardnessID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserId: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    PrDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    PrEndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    PrEndTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    SideNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    Side: {
      type: DataTypes.STRING(20),
      allowNull: true,
      defaultValue: "NULL"
    },
    Unit: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "NULL"
    },
    DecimalPoint: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    LimitOn: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      comment: "0: Actual 1 :Percentage"
    },
    BLName: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    NomHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    NomThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    NomDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    NomBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    T1NegTolHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosTolHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegTolThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosTolThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegTolDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosTolDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegTolBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1PosTolBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    T1NegTolActualHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    T1PosTolActualHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    T1NegTolActualThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    T1PosTolActualThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    T1NegTolActualDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    T1PosTolActualDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    T1NegTolActualBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    T1PosTolActualBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    ReportType: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue: "NULL"
    },
    PrintNo: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    IsArchived: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    BatchComplete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    CheckedByID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    CheckedByName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    CheckedByDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: "1992-12-08"
    },
    Lot: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    AvgHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    AvgThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    AvgDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    AvgBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MinWeightHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MaxWeightHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MinWeightThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MaxWeightThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MinWeightDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MaxWeightDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MinWeightBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    MaxWeightBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    StdDevHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    StdDevThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    StdDevDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    StdDevBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    RemarkHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    RemarkDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    RemarkThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    RemarkBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    Remark: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    FailedRemark: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "0"
    },
    FailedRemarkTSH: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "0"
    },
    Inprocess: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    HMIID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Layer: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    LayerName: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Nom_stdtarget: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTolHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTolHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTolThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTolThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTolDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTolDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTolBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTolBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTolActualHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTolActualHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTolActualThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTolActualThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTolActualDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTolActualDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2NegTolActualBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T2PosTolActualBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T3NegTolHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T3PosTolHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T3NegTolThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T3PosTolThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T3NegTolDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T3PosTolDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T3NegTolBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T3PosTolBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    T3NegTolActualHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    T3PosTolActualHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    T3NegTolActualThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    T3PosTolActualThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    T3NegTolActualDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    T3PosTolActualDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    T3NegTolActualBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    T3PosTolActualBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL",
    },
    CheckedByTime: {
      type: DataTypes.TIME,
      allowNull: true
    },
    MinPerHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    MaxPerHard: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    MinPerThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    MaxPerThick: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    MinPerDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    MaxPerDiam: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    MinPerBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    MaxPerBL: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "0"
    },
    Stage: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    }
  }, {
    sequelize,
    tableName: 'tbl_temp_masterhtd',
    timestamps: false,
    // indexes: [
    //   {
    //     name: "PRIMARY",
    //     unique: true,
    //     using: "BTREE",
    //     fields: [
    //       { name: "SrNo" },
    //     ]
    //   },
    //   {
    //     name: "index1",
    //     using: "BTREE",
    //     fields: [
    //       { name: "ProductType" },
    //       { name: "PrDate" },
    //       { name: "ReportType" },
    //     ]
    //   },
    // ]
  });
  seq.removeAttribute('id');
  return seq;
};
